Attribute VB_Name = "modPlugins"
'-----------------------------------------------------
' MirageBot Plugin Manager Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Plugins() As New clsPlug

Public Sub RefreshPlugins()
On Error GoTo hErr:
    Dim I As Integer, S() As String
    ReDim S(frmBot.mnuPlugin.UBound)
1   For I = frmBot.mnuPlugin.UBound To 1 Step -1
        S(I) = frmBot.mnuPlugin(I).Caption
2       Unload frmBot.mnuPlugin(I)
3   Next I
    S(0) = frmBot.mnuPlugin(0).Caption
    Debug.Print "Previous Plugins: " & Join(S, ", ")
4   frmBot.mnuPlugin(0).Caption = vbNullString
5   If SelectedBot = -1 Then Exit Sub
6   Dim F() As String
7   F = FileList(AppData & "Plugins\*.dll")
8   For I = 0 To UBound(F)
9       If LenB(F(I)) > 4 Then
10          With frmBot.mnuPlugin
                Dim P As String
                P = Left$(F(I), Len(F(I)) - 4)
11              If Len(.Item(0).Caption) > 0 Then Load frmBot.mnuPlugin(.Count)
12              .Item(.UBound).Caption = P
13              .Item(.UBound).Checked = frmBot.Bot(SelectedBot).PluginEnabled(P)
                Dim X As Integer, Loaded As Boolean
                For X = 0 To UBound(S)
                    If LenB(S(X)) > 0 Then
                        'Debug.Print "Compare: " & S(X) & " " & P
                        If LCase$(S(X)) = LCase$(P) Then
                            'Debug.Print "Matched!"
                            Loaded = True
                            Exit For
                        End If
                    End If
                Next X
                If Not Loaded Then
                    Debug.Print "Importing new plugin: " & P
                    ImportPlugin P
                    Dim B As BNCS
                    For Each B In frmBot.Bot
                        If B.IsLoaded Then PluginProfileLoaded B.BotIndex: Debug.Print "Tell plugin that the profile is loaded: " & B.Profile
                    Next B
                End If
                Loaded = False
            End With
        End If
    Next I
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Plugins", "RefreshPlugins"
End Sub

Public Function IsPlugin(ByVal Plugin As String) As Boolean
On Error Resume Next
    Dim I As Integer
    Plugin = LCase$(Plugin)
    For I = 1 To UBound(Plugins)
        If LCase$(Plugins(I).Name) = Plugin Then
            IsPlugin = True
            Exit Function
        End If
    Next I
    IsPlugin = False
End Function

Public Function CmdPlugin(ByVal Plugin As String) As String
    Dim C As clsPlugCommand, Temp As String
    For Each C In Commands
        If LCase$(Plugin) = LCase$(C.Plugin) Then
            Temp = Temp & C.Command & ", "
        End If
    Next C
    If LenB(Temp) Then
        Temp = Left$(Temp, Len(Temp) - 2)
        CmdPlugin = Temp
    End If
End Function
    
Public Sub DestroyPlugins()
On Error GoTo hErr:
    Dim X As Integer
    For X = UBound(Plugins) To 0 Step -1
        If LenB(Plugins(X).Name) > 0 Then
            Set Plugins(X).Client = Nothing
            Set Plugins(X) = Nothing
        End If
    Next X
    Erase Plugins()
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Plugins", "DestroyPlugins"
End Sub

Public Sub ImportPlugin(Name As String)
On Error GoTo hErr:
    Dim X As Integer
    For X = 0 To UBound(Plugins)
        If LCase$(Plugins(X).Name) = LCase$(Name) Then Exit Sub
    Next X

1   Dim P As New clsPlug, PI As New clsPlugCore, Ver As String
2   P.Path = AppData & "Plugins\" & Name & ".dll"
3   P.Name = Name
4   Shell "regsvr32 " & ChrW$(34) & P.Path & ChrW$(34) & " /s"
5   Set P.Client = CreateObject(P.Name & ".clsPlugin")
6   On Error Resume Next
10  Call P.Client.Plugin_Main(PI)
11  ReDim Preserve Plugins(UBound(Plugins) + 1)
12  Set Plugins(UBound(Plugins)) = P
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Plugins", "ImportPlugin" & " (" & P.Name & ")"
End Sub

Public Sub ImportPlugins()
On Error Resume Next
    Dim Files() As String, I As Integer
    ReDim Plugins(0)
    Files = FileList(AppData & "Plugins\*.dll")
    For I = 0 To UBound(Files)
        If Len(Files(I)) > 4 Then
            'Debug.Print Left$(Files(I), Len(Files(I)) - 4)
            ImportPlugin Left$(Files(I), Len(Files(I)) - 4)
        End If
    Next I
End Sub

Public Sub PluginProfileLoaded(Index As Integer)
On Error GoTo hErr:
    Dim I As Integer
    For I = 1 To UBound(Plugins)
        On Error GoTo NextPlugin:
        Plugins(I).Client.Plugin_Profile Index, True
NextPlugin:
        If Err Then Resume Next
    Next I
hErr:
End Sub

Public Sub PluginProfileUnloaded(Index As Integer)
On Error GoTo hErr:
    Dim I As Integer
    For I = 1 To UBound(Plugins)
        On Error GoTo NextPlugin:
        Plugins(I).Client.Plugin_Profile Index, False
NextPlugin:
        If Err Then Resume Next
    Next I
hErr:
End Sub

Public Sub PluginChatEvent(Index As Integer, EID As Long, Username As String, Message As String, Ping As Long, Flags As Long)
On Error GoTo hErr:
    Dim I As Integer
    For I = 1 To UBound(Plugins)
        On Error GoTo NextPlugin:
        If frmBot.Bot(Index).PluginEnabled(Plugins(I).Name) Then
            Select Case EID
            Case EID_BROADCAST
                Plugins(I).Client.Chat_Broadcast Index, Message
            Case EID_CHANNEL
                Plugins(I).Client.Chat_Channel Index, Message, Flags
            Case EID_CHANNELDOESNOTEXIST
                Plugins(I).Client.Chat_ChannelDoesNotExist Index
            Case EID_CHANNELFULL
                Plugins(I).Client.Chat_ChannelFull Index
            Case EID_CHANNELRESTRICTED
                Plugins(I).Client.Chat_ChannelRestricted Index
            Case EID_EMOTE
                Plugins(I).Client.Chat_UserEmote Index, Username, Message, Ping, Flags
            Case EID_ERROR
                Plugins(I).Client.Chat_Error Index, Message
            Case EID_INFO
                Plugins(I).Client.Chat_Information Index, Message
            Case EID_JOIN
                Plugins(I).Client.Chat_UserJoin Index, Username, Message, Ping, Flags
            Case EID_LEAVE
                Plugins(I).Client.Chat_UserLeave Index, Username
            Case EID_SHOWUSER
                Plugins(I).Client.Chat_UserPresent Index, Username, Message, Ping, Flags
            Case EID_TALK
                Plugins(I).Client.Chat_UserTalk Index, Username, Message, Ping, Flags
            Case EID_USERFLAGS
                Plugins(I).Client.Chat_UserUpdate Index, Username, Message, Ping, Flags
            Case EID_WHISPER
                Plugins(I).Client.Chat_WhisperFrom Index, Username, Message, Ping, Flags
            Case EID_WHISPERSENT
                Plugins(I).Client.Chat_WhisperTo Index, Username, Message, Ping, Flags
            Case EID_MODERATEUSER
                Plugins(I).Client.Chat_ModerateUser Index, Username, Message, Ping, Flags
            End Select
        End If
NextPlugin:
        If Err Then Resume Next
    Next I
hErr:
End Sub
